


**#定义路径
clear

global finaldata "D:\1 博士学习资料\学术研究\增值税减税并档\Data and Code 增值税减税并档\finaldata"
global output "D:\1 博士学习资料\学术研究\增值税减税并档\Data and Code 增值税减税并档\4 output"
**#


**#定义控制变量路径
global controls "Size Lev ROA FirmAge FIXED ATO Board Indep Dual Top1"	
global controls1 "Size Lev ROA FirmAge FIXED ATO "	
///
global controls_chain "Size Lev FirmAge PR Employee FIXED"
**#


**#描述性统计--本级企业
//本级企业全样本
clear
use "$finaldata/finaldata本级企业全样本描述性统计.dta"

	outreg2 using "$output/表2PanelA12本级企业描述性统计--全样本.xls", replace sum(log) keep(VAT_burden Invest ROI $controls) eqkeep(mean sd) title(全样本上市公司 Decriptive statistics)

//本级企业制造业样本
clear
use "$finaldata/finaldata本级企业制造业描述性统计.dta"

	outreg2 using "$output/表2PanelA34本级企业描述性统计--制造业企业.xls", replace sum(log) keep(VAT_burden Invest ROI $controls) eqkeep(mean sd) title(制造业上市公司 Decriptive statistics)

//本级企业服务业样本
clear
use "$finaldata/finaldata本级企业服务业描述性统计.dta"

	outreg2 using "$output/表2PanelA56本级企业描述性统计--服务业企业.xls", replace sum(log) keep(VAT_burden Invest ROI $controls) eqkeep(mean sd) title(服务业上市公司 Decriptive statistics)
**#



**#描述性统计--下游服务业
//中制-下服企业
clear
use "$finaldata/finaldata中制-下服描述性统计.dta"

	outreg2 using "$output/表2PanelB12下游企业描述性统计--中制-下服企业.xls", replace sum(log) keep(lnImput_VAT lnOmput_VAT Imput_VAT Omput_VAT VAT_burden Invest ROI AOI AOO $controls_chain ) eqkeep(mean sd) title(中制-下服企业 Decriptive statistics)

//中制-下制企业
clear
use "$finaldata/finaldata中制-下制描述性统计.dta"

	outreg2 using "$output/表2PanelB34下游企业描述性统计--中制-下制企业.xls", replace sum(log) keep(lnImput_VAT lnOmput_VAT Imput_VAT Omput_VAT VAT_burden Invest ROI AOI AOO $controls_chain) eqkeep(mean sd) title(中制-下制企业 Decriptive statistics)

//下游对照组企业
clear
use "$finaldata/finaldata下游对照组描述性统计.dta"

	outreg2 using "$output/表2PanelB56下游企业描述性统计--下游对照组企业.xls", replace sum(log) keep(lnImput_VAT lnOmput_VAT Imput_VAT Omput_VAT VAT_burden Invest ROI AOI AOO $controls_chain) eqkeep(mean sd) title(下游对照组企业 Decriptive statistics)
**#



**#表3 Panel A 个体企业视角
///Panel A（1）-（3）列，本级企业制造业税负///
clear
use "$finaldata/finaldata本级企业制造业-统一样本量.dta"

xtset id year

	xtreg VAT_burden DID i.year,fe cluster(id)	
		outreg2 using "$output/表3PanelA.xls",replace tstat bdec(7) tdec(3) keep(VAT_burden DID) addtext(年份固定效应,YES,个体固定效应,YES)

	xtreg VAT_burden DID $controls1 i.year,fe cluster(id)	
		outreg2 using "$output/表3PanelA.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID $controls1) addtext(年份固定效应,YES,个体固定效应,YES)
	
	xtreg VAT_burden DID $controls i.year,fe cluster(id)			//增值税税负下降
		outreg2 using "$output/表3PanelA.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

///平行趋势检验///
gen policy=year-2018
tab policy
forvalues i=2(-1)1{
	gen pre_`i' = (policy==-`i'&Treat制造业==1)
}
gen current=(policy==0&Treat制造业==1)
forvalues j=1(1)2{
	gen post_`j'=(policy==`j'&Treat制造业==1)
}
replace pre_1=0

	xtreg VAT_burden pre_2 pre_1 current post_1 post_2 $controls i.year,fe cluster(id)
	est store 本级企业制造业税负平行趋势 
///

///Panel A（4）-（6）列，本级企业服务业税负///
clear
use "$finaldata/finaldata本级企业服务业-统一样本量.dta"

xtset id year

	xtreg VAT_burden DID i.year,fe cluster(id) 
		outreg2 using "$output/表3PanelA.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID) addtext(年份固定效应,YES,个体固定效应,YES)

	xtreg VAT_burden DID $controls1 i.year,fe cluster(id)
		outreg2 using "$output/表3PanelA.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID $controls1) addtext(年份固定效应,YES,个体固定效应,YES)
	
	xtreg VAT_burden DID $controls i.year,fe cluster(id)
		outreg2 using "$output/表3PanelA.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

***平行趋势检验***
gen policy=year-2018
tab policy
forvalues i=2(-1)1{
	gen pre_`i' = (policy==-`i'&Treat除制造业外服务业==1)
}
gen current=(policy==0&Treat除制造业外服务业==1)
forvalues j=1(1)2{
	gen post_`j'=(policy==`j'&Treat除制造业外服务业==1)
}
replace pre_1=0

	xtreg VAT_burden pre_2 pre_1 current post_1 post_2 $controls i.year,fe cluster(id) 
	est store 本级企业服务业税负平行趋势 
**#

**#整合表3Panel A，本级制造业和服务业企业税负 平行趋势
clear
	coefplot ///
	(本级企业制造业税负平行趋势,label("本级公司制造业") offset(0.03) pstyle(p4) msymbol(s) mcolor(midblue) lcolor(midblue) lpattern(solid) ciopts(lpattern(dash) recast(rcap) msize(medium) lcolor(midblue))) ///
	(本级企业服务业税负平行趋势,label("本级公司服务业") offset(-0.03) pstyle(p2) msymbol(h) mcolor(red) lcolor(red) lpattern(solid) ciopts(lpattern(dash) recast(rcap) msize(medium) lcolor(red))), ///
	levels(95) keep(pre_2 pre_1 current post_1 post_2) ///
	vertical omitted ///
	recast(connect ) ///
	yline(0) xtitle("政策时点",size(small)) ytitle("政策动态效应",size(small)) ///
	ylabel(-0.01(0.005)0.01,labsize(*0.75) nogrid) xlabel(,labsize(*0.75)) ///
	yline(0,lcolor(edkblue*0.8)) xline(3,lpattern(dash) lcolor(black)) /// 
	graphregion(color(white)) ///
	legend( size(small) col(2)) ///
	title(" ",size(small)) ///
	scheme(s1mono)	
graph export "$output/表3PanelA平行趋势.png",replace
**#


**#表3 Panel B 供应链视角
//Panel B（1）-（3）列，制服供应链下游服务业企业进销项税额与税负
clear
use "$finaldata/finaldata中制-下服-统一样本量.dta"

xtset firm_id year 

	xtreg Imput_VAT DID $controls_chain i.year, fe cluster(firm_id)
		outreg2 using "$output/表3PanelB.xls",replace tstat bdec(7) tdec(3) keep(Imput_VAT DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
		
	xtreg Omput_VAT DID $controls_chain i.year, fe cluster(firm_id)
		outreg2 using "$output/表3PanelB.xls",append tstat bdec(7) tdec(3) keep(Omput_VAT DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)

	xtreg VAT_burden DID $controls_chain i.year,fe cluster(firm_id)		
		outreg2 using "$output/表3PanelB.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)

///平行趋势检验///
gen policy=year-2018
tab policy
forvalues i=2(-1)1{
	gen pre_`i' = (policy==-`i'&Treat_制服==1)
}
gen current=(policy==0&Treat_制服==1)
forvalues j=1(1)2{
	gen post_`j'=(policy==`j'&Treat_制服==1)
}
replace pre_1=0
	
	xtreg Imput_VAT pre_2 pre_1 current post_1 post_2 $controls_chain i.year,fe cluster(firm_id)
	est store 制服进项额平行趋势
	
	xtreg Omput_VAT pre_2 pre_1 current post_1 post_2 $controls_chain i.year,fe cluster(firm_id)
	est store 制服销项额平行趋势

	xtreg VAT_burden pre_2 pre_1 current post_1 post_2 $controls_chain i.year,fe cluster(firm_id)
	est store 制服增值税税负平行趋势
//

//Panel B（4）-（6）列，制制供应链下游制造业企业进销项税额与税负
clear
use "$finaldata/finaldata中制-下制-统一样本量.dta"

xtset firm_id year 

	xtreg Imput_VAT DID $controls_chain i.year, fe cluster(firm_id)	
		outreg2 using "$output/表3PanelB.xls",append tstat bdec(7) tdec(3) keep(Imput_VAT DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
	
	xtreg Omput_VAT DID $controls_chain i.year, fe cluster(firm_id)	
		outreg2 using "$output/表3PanelB.xls",append tstat bdec(7) tdec(3) keep(Omput_VAT DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
	
	xtreg VAT_burden DID $controls_chain i.year,fe cluster(firm_id)	
		outreg2 using "$output/表3PanelB.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)

///平行趋势检验///
gen policy=year-2018
tab policy
forvalues i=2(-1)1{
	gen pre_`i' = (policy==-`i'&Treat_制制==1)
}
gen current=(policy==0&Treat_制制==1)
forvalues j=1(1)2{
	gen post_`j'=(policy==`j'&Treat_制制==1)
}
replace pre_1=0

	xtreg Imput_VAT pre_2 pre_1 current post_1 post_2 $controls_chain i.year,fe cluster(firm_id)	
	est store 制制进项额平行趋势
	
	xtreg Omput_VAT pre_2 pre_1 current post_1 post_2 $controls_chain i.year,fe cluster(firm_id)	
	est store 制制销项额平行趋势
	
	xtreg VAT_burden pre_2 pre_1 current post_1 post_2 $controls_chain i.year,fe cluster(firm_id)			 
	est store 制制增值税税负平行趋势
**#

**#整合表3Panel B，制服与制制下游企业进销项税额与税负 平行趋势
//进项税额
clear
	coefplot ///
	(制服进项额平行趋势,label("“制造业-制造业”供应链") offset(0.03) pstyle(p4) msymbol(s) mcolor(midblue) lcolor(midblue) lpattern(solid) ciopts(lpattern(dash) recast(rcap) msize(medium) lcolor(midblue))) ///
	(制制进项额平行趋势,label("“制造业-服务业”供应链") offset(-0.03) pstyle(p2) msymbol(h) mcolor(red) lcolor(red) lpattern(solid) ciopts(lpattern(dash) recast(rcap) msize(medium) lcolor(red))), ///
	levels(95) keep(pre_2 pre_1 current post_1 post_2) ///
	vertical omitted ///
	recast(connect ) ///
	yline(0) xtitle("政策时点",size(small)) ytitle("政策动态效应",size(small)) ///
	ylabel(-0.05(0.01)0.02,labsize(*0.75) nogrid) xlabel(,labsize(*0.75)) ///
	yline(0,lcolor(edkblue*0.8)) xline(3,lpattern(dash) lcolor(black)) /// 
	graphregion(color(white)) ///
	legend( size(small) col(2)) ///
	title("",size(small)) ///
	scheme(s1mono)		
graph export "$output/表3PanelB平行趋势-进项税额.png",replace

//销项税额
clear
	coefplot ///
	(制服销项额平行趋势,label("“制造业-制造业”供应链") offset(0.03) pstyle(p4) msymbol(s) mcolor(midblue) lcolor(midblue) lpattern(solid) ciopts(lpattern(dash) recast(rcap) msize(medium) lcolor(midblue))) ///
	(制制销项额平行趋势,label("“制造业-服务业”供应链") offset(-0.03) pstyle(p2) msymbol(h) mcolor(red) lcolor(red) lpattern(solid) ciopts(lpattern(dash) recast(rcap) msize(medium) lcolor(red))), ///
	levels(95) keep(pre_2 pre_1 current post_1 post_2) ///
	vertical omitted ///
	recast(connect ) ///
	yline(0) xtitle("政策时点",size(small)) ytitle("政策动态效应",size(small)) ///
	ylabel(-0.03(0.01)0.01,labsize(*0.75) nogrid) xlabel(,labsize(*0.75)) ///
	yline(0,lcolor(edkblue*0.8)) xline(3,lpattern(dash) lcolor(black)) /// 
	graphregion(color(white)) ///
	legend( size(small) col(2)) ///
	title("",size(small)) ///
	scheme(s1mono)		
graph export "$output/表3PanelB平行趋势-销项税额.png",replace

//增值税税负
clear
	coefplot ///
	(制制增值税税负平行趋势,label("“制造业-制造业”供应链") offset(0.03) pstyle(p4) msymbol(s) mcolor(midblue) lcolor(midblue) lpattern(solid) ciopts(lpattern(dash) recast(rcap) msize(medium) lcolor(midblue))) ///
	(制服增值税税负平行趋势,label("“制造业-服务业”供应链") offset(-0.03) pstyle(p2) msymbol(h) mcolor(red) lcolor(red) lpattern(solid) ciopts(lpattern(dash) recast(rcap) msize(medium) lcolor(red))), ///
	levels(95) keep(pre_2 pre_1 current post_1 post_2) ///
	vertical omitted ///
	recast(connect ) ///
	yline(0) xtitle("政策时点",size(small)) ytitle("政策动态效应",size(small)) ///
	ylabel(-0.02(0.01)0.03,labsize(*0.75) nogrid) xlabel(,labsize(*0.75)) ///
	yline(0,lcolor(edkblue*0.8)) xline(3,lpattern(dash) lcolor(black)) /// 
	graphregion(color(white)) ///
	legend( size(small) col(2)) ///
	title(" ",size(small)) ///
	scheme(s1mono)	
graph export "$output/表3PanelB平行趋势-增值税税负.png",replace
**#



**#表4 增值税减税下的投资分化
//表4（1）（2）列，本级公司制造业投资与投资收益
clear
use "$finaldata/finaldata本级企业制造业-统一样本量.dta"

xtset id year

//企业投资
	xtreg Invest DID $controls i.year,fe cluster(id)
		outreg2 using "$output/表4.xls",replace tstat bdec(7) tdec(3) keep(Invest DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)
//企业投资收益
	xtreg ROI DID $controls i.year,fe cluster(id)  
		outreg2 using "$output/表4.xls",append tstat bdec(7) tdec(3) keep(ROI DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)


//表4（3）（4）列，制服供应链下游服务业企业下游企业投资与投资收益
clear
use "$finaldata/finaldata中制-下服-统一样本量.dta"

xtset firm_id year 

//企业投资
	xtreg Invest DID $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/表4.xls",append tstat bdec(7) tdec(3) keep(Invest DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
//企业投资收益
	xtreg ROI DID $controls_chain i.year,fe cluster(firm_id)	 
		outreg2 using "$output/表4.xls",append tstat bdec(7) tdec(3) keep(ROI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)


//表4（5）（6）列，制制供应链下游制造业企业下游企业投资与投资收益
clear
use "$finaldata/finaldata中制-下制-统一样本量.dta"

xtset firm_id year 

//企业投资
	xtreg Invest DID $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/表4.xls",append tstat bdec(7) tdec(3) keep(Invest DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
//企业投资收益
	xtreg ROI DID $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/表4.xls",append tstat bdec(7) tdec(3) keep(ROI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
**#




**#表5 Panel A 增值税减税下的纵向一体化：供应链视角
//表5 Panel A（1）（2）（3）列，制服纵向一体化
clear
use "$finaldata/finaldata上制-中服.dta"

xtset id year

	xtreg VAS DID $controls i.year,fe cluster(id)
		outreg2 using "$output/表5PanelA.xls",replace tstat bdec(7) tdec(3) keep(VAS DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)
		
	xtreg 上游度 DID $controls i.year,fe cluster(id)
		outreg2 using "$output/表5PanelA.xls",append tstat bdec(7) tdec(3) keep(上游度 DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)
		
	xtreg 外包时间 DID $controls i.year,fe cluster(id)
		outreg2 using "$output/表5PanelA.xls",append tstat bdec(7) tdec(3) keep(外包时间 DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)
//


//表5 Panel A（4）（5）（6）列，制制纵向一体化
clear
use "$finaldata/finaldata上制-中制.dta"

xtset id year

	xtreg VAS DID $controls i.year,fe cluster(id)
		outreg2 using "$output/表5PanelA.xls",append tstat bdec(7) tdec(3) keep(VAS DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

	xtreg 上游度 DID $controls i.year,fe cluster(id)
		outreg2 using "$output/表5PanelA.xls",append tstat bdec(7) tdec(3) keep(上游度 DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)
		
	xtreg 外包时间 DID $controls i.year,fe cluster(id)
		outreg2 using "$output/表5PanelA.xls",append tstat bdec(7) tdec(3) keep(外包时间 DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)
**#



**#表5 Panel B 企业融资约束--现金流与企业信贷
//表5 Panel B（1）（2）列，本级制造业企业现金流与企业信贷
clear
use "$finaldata/finaldata本级企业制造业-统一样本量.dta"

	xtreg CF DID $controls i.year,fe cluster(id)	
		outreg2 using "$output/表5PanelB-现金流入和信贷.xls",replace tstat bdec(7) tdec(3) keep(CF DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

	xtreg Flex DID $controls i.year,fe cluster(id)	
		outreg2 using "$output/表5PanelB-现金流入和信贷.xls",append tstat bdec(7) tdec(3) keep(Flex DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

//表5 Panel B（3）（4）列，制服现金流与企业信贷
clear
use "$finaldata/finaldata中制-下服-统一样本量.dta"

xtset firm_id year 
	
	xtreg CF DID $controls_chain  i.year,fe cluster(firm_id)	
		outreg2 using "$output/表5PanelB-现金流入和信贷.xls",append tstat bdec(7) tdec(3) keep(CF DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)

	xtreg Flex DID $controls_chain  i.year,fe cluster(firm_id)	
		outreg2 using "$output/表5PanelB-现金流入和信贷.xls",append tstat bdec(7) tdec(3) keep(Flex DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)

	
//表5 Panel B（5）（6）列，制制现金流与企业信贷
clear
use "$finaldata/finaldata中制-下制-统一样本量.dta"

xtset firm_id year 

	xtreg CF DID $controls_chain i.year,fe cluster(firm_id)	
		outreg2 using "$output/表5PanelB-现金流入和信贷.xls",append tstat bdec(7) tdec(3) keep(CF DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)

	xtreg Flex DID $controls_chain  i.year,fe cluster(firm_id)	
		outreg2 using "$output/表5PanelB-现金流入和信贷.xls",append tstat bdec(7) tdec(3) keep(Flex DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
**#



**#表6--成本收益分析
//本级制造业
clear
use "$finaldata/finaldata本级企业制造业-统一样本量.dta"

xtset id year

//首先获得本级制造业减税幅度--0.0038167 即0.382%
	xtreg VAT_burden DID $controls i.year,fe cluster(id)

keep if Treat制造业==1		//只保留本级制造业企业，把对照组删除
//求出企业平均营业收入和投资水平
mean 营业总收入 		//算出为98.369亿元

//算出企业平均数量
preserve
duplicates drop id ,force
egen 企业数量=count (id) 
duplicates drop 企业数量 ,force
keep 企业数量
tab 企业数量		//企业数量为2555家
restore
//


//下游服务业
clear
use "$finaldata/finaldata中制-下服-统一样本量.dta"

xtset firm_id year

//首先获得下游服务业税负上升幅度--0.0101921即1.019%
	xtreg VAT_burden DID $controls_chain i.year,fe cluster(firm_id)	

keep if Treat_制服==1		///只保留下游服务业，把对照组删除
//求出企业平均营业收入
mean 营业收入		//算出为23.018亿元

//算出企业平均数量
preserve
duplicates drop firm_id ,force
egen 企业数量=count (firm_id) 
duplicates drop 企业数量 ,force
keep 企业数量
tab 企业数量	//企业数量为730家
restore
**#


**#

	**************
	*****附录*****
	**************
**#





**#附录4，更换进销项税额衡量方式
//附录4表1（1）（2）列，制服进销项
clear
use "$finaldata/finaldata中制-下服-统一样本量.dta"

xtset firm_id year 

drop if lnImput_VAT==.		//统一样本量
drop if lnOmput_VAT==.		//统一样本量

	xtreg lnImput_VAT DID $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录4表1.xls",replace tstat bdec(7) tdec(3) keep(lnImput_VAT DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
		
	xtreg lnOmput_VAT DID $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录4表1.xls",append tstat bdec(7) tdec(3) keep(lnOmput_VAT DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
///

///附录4表1（3）（4）列，制制进销项
clear
use "$finaldata/finaldata中制-下制-统一样本量.dta"

xtset firm_id year 

drop if lnImput_VAT==.		//统一样本量
drop if lnOmput_VAT==.		//统一样本量

	xtreg lnImput_VAT DID $controls_chain i.year,fe cluster(firm_id)	
		outreg2 using "$output/附录4表1.xls",append tstat bdec(7) tdec(3) keep(lnImput_VAT DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
		
	xtreg lnOmput_VAT DID $controls_chain i.year,fe cluster(firm_id)	
		outreg2 using "$output/附录4表1.xls",append tstat bdec(7) tdec(3) keep(lnOmput_VAT DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
**#



**#附录5，商业信用指标--对结果不会产生影响
//附录5表1（1）-（4）列，下游服务业
clear
use "$finaldata/finaldata上制-中服.dta"

xtset id year

	xtreg NTC DID i.year,fe cluster(id)
		outreg2 using "$output/附录5表1.xls",replace tstat bdec(7) tdec(3) keep(NTC DID) addtext(年份固定效应,YES,个体固定效应,YES)
	
	xtreg NTC DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录5表1.xls",append tstat bdec(7) tdec(3) keep(NTC DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)
		
	xtreg LAP DID i.year,fe cluster(id)
		outreg2 using "$output/附录5表1.xls",append tstat bdec(7) tdec(3) keep(LAP DID) addtext(年份固定效应,YES,个体固定效应,YES)
	
	xtreg LAP DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录5表1.xls",append tstat bdec(7) tdec(3) keep(LAP DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

//附录5表1（5）-（8）列，下游制造业
clear
use "$finaldata/finaldata上制-中制.dta"

xtset id year

	xtreg NTC DID i.year,fe cluster(id)
		outreg2 using "$output/附录5表1.xls",append tstat bdec(7) tdec(3) keep(NTC DID) addtext(年份固定效应,YES,个体固定效应,YES)
	
	xtreg NTC DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录5表1.xls",append tstat bdec(7) tdec(3) keep(NTC DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)
	
	xtreg LAP DID i.year,fe cluster(id)
		outreg2 using "$output/附录5表1.xls",append tstat bdec(7) tdec(3) keep(LAP DID) addtext(年份固定效应,YES,个体固定效应,YES)
	
	xtreg LAP DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录5表1.xls",append tstat bdec(7) tdec(3) keep(LAP DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)
**#



**#附录6 增值税减税下的销售额差异：供应链视角
//附录6表1 （1）（2）列，制服进项额和销项额
clear
use "$finaldata/finaldata中制-下服-统一样本量.dta"

xtset firm_id year 

drop if AOI==.		//统一样本量
drop if AOO==.		//统一样本量

	xtreg AOI DID $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录6表1.xls",replace tstat bdec(7) tdec(3) keep(AOI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
	
	xtreg AOO DID $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录6表1.xls",append tstat bdec(7) tdec(3) keep(AOO DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)

//附录6表1（3）（4）列，	制制进项额和销项额
clear
use "$finaldata/finaldata中制-下制-统一样本量.dta"

xtset firm_id year 

drop if AOI==.		//统一样本量
drop if AOO==.		//统一样本量
	
	xtreg AOI DID $controls_chain i.year,fe cluster(firm_id)  
		outreg2 using "$output/附录6表1.xls",append tstat bdec(7) tdec(3) keep(AOI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
		
	xtreg AOO DID $controls_chain i.year,fe  cluster(firm_id)
		outreg2 using "$output/附录6表1.xls",append tstat bdec(7) tdec(3) keep(AOO DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
**#



**#附录10 企业市场势力
//附录10表1（1）列，"制造业-服务业"供应链上游制造业企业
clear
use "$finaldata/finaldata中制-下服的本级制造业.dta"

xtset id year

	xtreg HHI DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录10表1.xls",replace tstat bdec(7) tdec(3) keep(HHI DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)
//

//附录10表1（2）列，"制造业-服务业"供应链上游行业勒纳指数
clear
use "$finaldata/finaldata中制-下服的本级行业.dta"

	xtreg 行业勒纳 DID 行业Size 行业Lev 行业ROA 行业FirmAge 行业ATO 行业FIXED 行业Board 行业Indep 行业Dual 行业Top1 i.year,fe cluster(上市公司行业代码C_编码)
		outreg2 using "$output/附录10表1.xls",append tstat bdec(7) tdec(3) keep(行业勒纳 DID 行业Size 行业Lev 行业ROA 行业FirmAge 行业ATO 行业FIXED 行业Board 行业Indep 行业Dual 行业Top1) addtext(年份固定效应,YES,个体固定效应,YES)

//附录10表1（3）列，"制造业-服务业"供应链下游服务业企业
clear
use "$finaldata/finaldata上制-中服的本级服务业.dta"
	
xtset id year

	xtreg HHI DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录10表1.xls",append tstat bdec(7) tdec(3) keep(HHI DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

//附录10表1（4）列，"制造业-服务业"供应链下游行业勒纳指数
clear
use "$finaldata/finaldata上制-中服的本级行业.dta"

	xtreg 行业勒纳 DID 行业Size 行业Lev 行业ROA 行业FirmAge 行业ATO 行业FIXED 行业Board 行业Indep 行业Dual 行业Top1 i.year,fe cluster(上市公司行业代码C_编码)
		outreg2 using "$output/附录10表1.xls",append tstat bdec(7) tdec(3) keep(行业勒纳 DID 行业Size 行业Lev 行业ROA 行业FirmAge 行业ATO 行业FIXED 行业Board 行业Indep 行业Dual 行业Top1) addtext(年份固定效应,YES,个体固定效应,YES)


//附录10表2（1）（2）列，"制造业-服务业"供应链上游制造业企业原始HHI指数
clear
use "$finaldata/finaldata中制-下服的本级制造业.dta"

xtset id year

	xtreg HHI_主营业务收入 DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录10表2.xls",replace tstat bdec(7) tdec(3) keep(HHI_主营业务收入 DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

	xtreg HHI_所有者权益 DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录10表2.xls",append tstat bdec(7) tdec(3) keep(HHI_所有者权益 DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

//附录10表2（3）（4）列，"制造业-服务业"供应链下游服务业企业原始HHI指数
clear
use "$finaldata/finaldata上制-中服的本级服务业.dta"

xtset id year

	xtreg HHI_主营业务收入 DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录10表2.xls",append tstat bdec(7) tdec(3) keep(HHI_主营业务收入 DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

	xtreg HHI_所有者权益 DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录10表2.xls",append tstat bdec(7) tdec(3) keep(HHI_所有者权益 DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)

**#



**#附录11，稳健性检验，企业所得税税负
//附录11表1（1）列，本级公司制造业
clear
use "$finaldata/finaldata本级企业制造业-统一样本量.dta"

xtset id year

	xtreg 所得税税负 DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录11表1.xls",replace tstat bdec(7) tdec(3) keep(所得税税负 DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)	
///

///附录11表1（2）列，本级公司服务业
clear
use "$finaldata/finaldata本级企业服务业-统一样本量.dta"

xtset id year

	xtreg 所得税税负 DID $controls i.year,fe cluster(id)
		outreg2 using "$output/附录11表1.xls",append tstat bdec(7) tdec(3) keep(所得税税负 DID $controls) addtext(年份固定效应,YES,个体固定效应,YES)	
///

///附录11表1（3）列，制服
clear
use "$finaldata/finaldata中制-下服-统一样本量.dta"

xtset firm_id year 

	xtreg 所得税税负 DID $controls_chain i.year ,fe cluster(firm_id)
		outreg2 using "$output/附录11表1.xls",append tstat bdec(7) tdec(3) keep(所得税税负 DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
///

///附录11表1（4）列，制制
clear
use "$finaldata/finaldata中制-下制-统一样本量.dta"

xtset firm_id year 

	xtreg 所得税税负 DID $controls_chain i.year ,fe cluster(firm_id)
		outreg2 using "$output/附录11表1.xls",append tstat bdec(7) tdec(3) keep(所得税税负 DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
**#



**#附录11--剔除可能有影响样本后的稳健性，排除同期政策的影响
**#制服
//税负
clear
use "$finaldata/finaldata中制-下服-统一样本量.dta"

xtset firm_id year 

//删除小规模纳税人
preserve
	drop if 是否为小规模纳税人==1
	xtreg VAT_burden DID $controls_chain  i.year,fe cluster(firm_id)	
		outreg2 using "$output/附录11表2-删除小规模纳税人.xls",replace tstat bdec(7) tdec(3) keep(VAT_burden DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//删除增值税年报企业
preserve
	drop if 是否为增值税年报企业==1
	xtreg VAT_burden DID $controls_chain  i.year,fe cluster(firm_id)		
		outreg2 using "$output/附录11表2-删除增值税年报企业.xls",replace tstat bdec(7) tdec(3) keep(VAT_burden DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//删除自贸区企业
preserve
	drop if 是否自贸区企业==1
	xtreg VAT_burden DID $controls_chain  i.year,fe cluster(firm_id)		
		outreg2 using "$output/附录11表2-删除自贸区企业.xls",replace tstat bdec(7) tdec(3) keep(VAT_burden DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore
	
	
//控制留抵退税政策
preserve
	xtreg VAT_burden DID 留抵退税Dummy $controls_chain  i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制留抵退税政策.xls",replace tstat bdec(7) tdec(3) keep(VAT_burden DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//控制减税降费政策
preserve
	xtreg VAT_burden DID 减税降费 $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制减税降费政策.xls",replace tstat bdec(8) tdec(3) keep(VAT_burden DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//控制所得税减半征收政策
preserve
	xtreg VAT_burden DID 减半征收政策Dummy $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制所得税减半征收政策.xls",replace tstat bdec(7) tdec(3) keep(VAT_burden DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//投资
clear
use "$finaldata/finaldata中制-下服-统一样本量.dta"

xtset firm_id year 

//删除小规模纳税人
preserve
	drop if 是否为小规模纳税人==1
	xtreg Invest DID $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表2-删除小规模纳税人.xls",append tstat bdec(7) tdec(3) keep(Invest DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//删除增值税年报企业
preserve
	drop if 是否为增值税年报企业==1
	xtreg Invest DID $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表2-删除增值税年报企业.xls",append tstat bdec(7) tdec(3) keep(Invest DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore

//删除自贸区企业
preserve
	drop if 是否自贸区企业==1
	xtreg Invest DID $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表2-删除自贸区企业.xls",append tstat bdec(7) tdec(3) keep(Invest DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)		
restore
	
	
//控制留抵退税政策-留抵退税Dummy
preserve
	xtreg Invest DID 留抵退税Dummy $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表3-控制留抵退税政策.xls",append tstat bdec(7) tdec(3) keep(Invest DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//控制减税降费政策-减税降费
preserve
	xtreg Invest DID 减税降费 $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表3-控制减税降费政策.xls",append tstat bdec(8) tdec(3) keep(Invest DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//控制所得税减半征收政策-减半征收政策Dummy
preserve
	xtreg Invest DID 减半征收政策Dummy $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表3-控制所得税减半征收政策.xls",append tstat bdec(7) tdec(3) keep(Invest DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
restore


//投资收益
clear
use "$finaldata/finaldata中制-下服-统一样本量.dta"

xtset firm_id year 

//删除小规模纳税人
preserve
	drop if 是否为小规模纳税人==1
	xtreg ROI DID $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表2-删除小规模纳税人.xls",append tstat bdec(7) tdec(3) keep(ROI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore

//删除增值税年报企业
preserve
	drop if 是否为增值税年报企业==1
	xtreg ROI DID $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表2-删除增值税年报企业.xls",append tstat bdec(7) tdec(3) keep(ROI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore

//删除自贸区企业
preserve
	drop if 是否自贸区企业==1
	xtreg ROI DID $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表2-删除自贸区企业.xls",append tstat bdec(7) tdec(3) keep(ROI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)		
restore
	
	
//控制留抵退税政策-留抵退税Dummy
preserve
	xtreg ROI DID 留抵退税Dummy $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表3-控制留抵退税政策.xls",append tstat bdec(7) tdec(3) keep(ROI DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
restore


//控制减税降费政策-减税降费
preserve
	xtreg ROI DID 减税降费 $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表3-控制减税降费政策.xls",append tstat bdec(8) tdec(3) keep(ROI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//控制所得税减半征收政策-减半征收政策Dummy
preserve
	xtreg ROI DID 减半征收政策Dummy $controls_chain i.year,fe cluster(firm_id) 
		outreg2 using "$output/附录11表3-控制所得税减半征收政策.xls",append tstat bdec(7) tdec(3) keep(ROI DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
restore
**#



**#制制
//税负
clear
use "$finaldata/finaldata中制-下制-统一样本量.dta"

xtset firm_id year 

//删除小规模纳税人
preserve
	drop if 是否为小规模纳税人==1
	xtreg VAT_burden DID $controls_chain  i.year,fe cluster(firm_id)	
		outreg2 using "$output/附录11表2-删除小规模纳税人.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//删除增值税年报企业
preserve
	drop if 是否为增值税年报企业==1
	xtreg VAT_burden DID $controls_chain  i.year,fe cluster(firm_id)		
		outreg2 using "$output/附录11表2-删除增值税年报企业.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
restore


//删除自贸区企业
preserve
	drop if 是否自贸区企业==1
	xtreg VAT_burden DID $controls_chain  i.year,fe cluster(firm_id)		
		outreg2 using "$output/附录11表2-删除自贸区企业.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
restore
	
	
//控制留抵退税政策
preserve
	xtreg VAT_burden DID 留抵退税Dummy $controls_chain  i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制留抵退税政策.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID  $controls_chain ) addtext(年份固定效应,YES,个体固定效应,YES)
restore


//控制减税降费政策
preserve
	xtreg VAT_burden DID 减税降费 $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制减税降费政策.xls",append tstat bdec(8) tdec(3) keep(VAT_burden DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//控制所得税减半征收政策
preserve
	xtreg VAT_burden DID 减半征收政策Dummy $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制所得税减半征收政策.xls",append tstat bdec(7) tdec(3) keep(VAT_burden DID  $controls_chain ) addtext(年份固定效应,YES,个体固定效应,YES)
restore


//投资
clear
use "$finaldata/finaldata中制-下制-统一样本量.dta"

xtset firm_id year 

//删除小规模纳税人
preserve
	drop if 是否为小规模纳税人==1
	xtreg Invest DID $controls_chain  i.year,fe cluster(firm_id)	
		outreg2 using "$output/附录11表2-删除小规模纳税人.xls",append tstat bdec(7) tdec(3) keep(Invest DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore

//删除增值税年报企业
preserve
	drop if 是否为增值税年报企业==1
	xtreg Invest DID $controls_chain  i.year,fe cluster(firm_id)		
		outreg2 using "$output/附录11表2-删除增值税年报企业.xls",append tstat bdec(7) tdec(3) keep(Invest DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
restore

//删除自贸区企业
preserve
	drop if 是否自贸区企业==1
	xtreg Invest DID $controls_chain  i.year,fe cluster(firm_id)		
		outreg2 using "$output/附录11表2-删除自贸区企业.xls",append tstat bdec(7) tdec(3) keep(Invest DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
restore
	
	
//控制留抵退税政策
preserve
	xtreg Invest DID 留抵退税Dummy $controls_chain  i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制留抵退税政策.xls",append tstat bdec(7) tdec(3) keep(Invest DID  $controls_chain ) addtext(年份固定效应,YES,个体固定效应,YES)
restore


//控制减税降费政策
preserve
	xtreg Invest DID 减税降费 $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制减税降费政策.xls",append tstat bdec(8) tdec(3) keep(Invest DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//控制所得税减半征收政策
preserve
	xtreg Invest DID 减半征收政策Dummy $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制所得税减半征收政策.xls",append tstat bdec(7) tdec(3) keep(Invest DID  $controls_chain ) addtext(年份固定效应,YES,个体固定效应,YES)
restore


//投资收益
clear
use "$finaldata/finaldata中制-下制-统一样本量.dta"

xtset firm_id year 

//删除小规模纳税人
preserve
	drop if 是否为小规模纳税人==1
	xtreg ROI DID $controls_chain  i.year,fe cluster(firm_id)	
		outreg2 using "$output/附录11表2-删除小规模纳税人.xls",append tstat bdec(7) tdec(3) keep(ROI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore

//删除增值税年报企业
preserve
	drop if 是否为增值税年报企业==1
	xtreg ROI DID $controls_chain  i.year,fe cluster(firm_id)		
		outreg2 using "$output/附录11表2-删除增值税年报企业.xls",append tstat bdec(7) tdec(3) keep(ROI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
restore

//删除自贸区企业
preserve
	drop if 是否自贸区企业==1
	xtreg ROI DID $controls_chain  i.year,fe cluster(firm_id)		
		outreg2 using "$output/附录11表2-删除自贸区企业.xls",append tstat bdec(7) tdec(3) keep(ROI DID $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)
restore
	
	
//控制留抵退税政策
preserve
	xtreg ROI DID 留抵退税Dummy $controls_chain  i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制留抵退税政策.xls",append tstat bdec(7) tdec(3) keep(ROI DID  $controls_chain ) addtext(年份固定效应,YES,个体固定效应,YES)
restore


//控制减税降费政策
preserve
	xtreg ROI DID 减税降费 $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制减税降费政策.xls",append tstat bdec(8) tdec(3) keep(ROI DID  $controls_chain) addtext(年份固定效应,YES,个体固定效应,YES)	
restore


//控制所得税减半征收政策
preserve
	xtreg ROI DID 减半征收政策Dummy $controls_chain i.year,fe cluster(firm_id)
		outreg2 using "$output/附录11表3-控制所得税减半征收政策.xls",append tstat bdec(7) tdec(3) keep(ROI DID  $controls_chain ) addtext(年份固定效应,YES,个体固定效应,YES)
restore
**#



**#置换检验

//本级制造业企业税负置换检验
clear
	use "$output/permute/simulation本级制造业税负置换检验.dta",clear
	gen t_value = beta/se
	gen p_value = 2 * ttail(df, abs(beta/se))
	#delimit;
	dpplot t_value,
		msize(*0.3) mcolor(black) 
		xline(-3.53 , lc(red) lp(dash)) 
		xlabel(-4 -3.53  -2(1)4)
		xtitle("t值",size(*0.8)) xlabel(,labsize(small))
		ytitle("概率密度",size(*0.8)) ylabel(, nogrid format(%4.1f) labsize(small))
		note("") caption("") 
		graphregion(fcolor(white));
	#delimit cr
graph export "$output/permute/置换检验1-本级制造业企业税负置换.png",replace
///


//本级服务业企业税负置换检验
clear
	use "$output/permute/simulation本级服务业税负置换检验.dta",clear
	gen t_value = beta/se
	gen p_value = 2 * ttail(df, abs(beta/se))
	#delimit;
	dpplot t_value,
		msize(*0.3) mcolor(black) 
		xline(3.00 , lc(red) lp(dash)) 
		xlabel(-4 (1)4 3.00 )
		xtitle("t值",size(*0.8)) xlabel(,labsize(small))
		ytitle("概率密度",size(*0.8)) ylabel(, nogrid format(%4.1f) labsize(small))
		note("") caption("") 
		graphregion(fcolor(white));
	#delimit cr
graph export "$output/permute/置换检验2-本级服务业企业税负置换.png",replace


//制服下游服务业企业税负置换检验
clear
	use "$output/permute/simulation下游服务业税负置换检验.dta",clear
	gen t_value = beta/se
	gen p_value = 2 * ttail(df, abs(beta/se))
	#delimit;
	dpplot t_value,
		msize(*0.3) mcolor(black) 
		xline(1.95, lc(red) lp(dash)) 
		xlabel(-4 (1)1 1.95 3 4)
		xtitle("t值",size(*0.8)) xlabel(,labsize(small))
		ytitle("概率密度",size(*0.8)) ylabel(, nogrid format(%4.1f) labsize(small))
		note("") caption("") 
		graphregion(fcolor(white));
	#delimit cr
graph export "$output/permute/置换检验3-下游服务业企业税负置换.png",replace


//本级制造业投资置换检验
clear
	use "$output/permute/simulation本级制造业投资置换检验.dta",clear
	gen t_value = beta/se
	gen p_value = 2 * ttail(df, abs(beta/se))
	#delimit;
	dpplot t_value,
		msize(*0.3) mcolor(black) 
		xline( 2.84 , lc(red) lp(dash)) 
		xlabel(-4 (1)1 2 2.84 4)
		xtitle("t值",size(*0.8)) xlabel(,labsize(small))
		ytitle("概率密度",size(*0.8)) ylabel(, nogrid format(%4.1f) labsize(small))
		note("") caption("") 
		graphregion(fcolor(white));
	#delimit cr
graph export "$output/permute/置换检验4-本级制造业投资置换.png",replace

//本级制造业投资收益置换检验
clear
	use "$output/permute/simulation本级制造业投资收益置换检验.dta",clear
	gen t_value = beta/se
	gen p_value = 2 * ttail(df, abs(beta/se))
	#delimit;
	dpplot t_value,
		msize(*0.3) mcolor(black) 
		xline(1.80, lc(red) lp(dash)) 
		xlabel(-4 (1)1 1.80 3 4)
		xtitle("t值",size(*0.8)) xlabel(,labsize(small))
		ytitle("概率密度",size(*0.8)) ylabel(, nogrid format(%4.1f) labsize(small))
		note("") caption("") 
		graphregion(fcolor(white));
	#delimit cr
graph export "$output/permute/置换检验5-本级制造业投资收益置换.png",replace


//制服下游服务业投资置换检验
clear
	use "$output/permute/simulation下游服务业投资置换检验.dta",clear
	gen t_value = beta/se
	gen p_value = 2 * ttail(df, abs(beta/se))
	#delimit;
	dpplot t_value,
		msize(*0.3) mcolor(black) 
		xline(-1.81, lc(red) lp(dash)) 
		xlabel(-4 -3  -1.81 -1(1) 4)
		xtitle("t值",size(*0.8)) xlabel(,labsize(small))
		ytitle("概率密度",size(*0.8)) ylabel(, nogrid format(%4.1f) labsize(small))
		note("") caption("") 
		graphregion(fcolor(white));
	#delimit cr
graph export "$output/permute/置换检验6-下游服务业投资置换.png",replace


//制服下游服务业投资收益置换检验
clear
	use "$output/permute/simulation下游服务业投资收益置换检验.dta",clear
	gen t_value = beta/se
	gen p_value = 2 * ttail(df, abs(beta/se))
	#delimit;
	dpplot t_value,
		msize(*0.3) mcolor(black) 
		xline(-2.40, lc(red) lp(dash)) 
		xlabel(-2.40 -4(1) 4)
		xtitle("t值",size(*0.8)) xlabel(,labsize(small))
		ytitle("概率密度",size(*0.8)) ylabel(, nogrid format(%4.1f) labsize(small))
		note("") caption("") 
		graphregion(fcolor(white));
	#delimit cr
graph export "$output/permute/置换检验7-下游服务业投资收益置换.png",replace













